/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.EntityType;

@Singleton
public class EntityAssetTypeDictionary {
    private final Map<EntityType, Map<String, EntityAssetType>> byEntityType = new HashMap<EntityType, Map<String, EntityAssetType>>();
    private final List<EntityAssetType> all = new ArrayList<EntityAssetType>();
    private final Map<String, EntityAssetType> allByName = new HashMap<String, EntityAssetType>();

    @Inject
    public EntityAssetTypeDictionary() throws IOException {
        this(new File("assets/definitions/entityAssets/entityAssetTypes.json"));
    }

    public EntityAssetTypeDictionary(File assetTypesJsonFile) throws IOException {
        JSONObject assetTypesJson = JSON.parseObject(FileUtils.readFileToString(assetTypesJsonFile, "UTF-8"));
        for (String typeString : assetTypesJson.keySet()) {
            if (typeString.startsWith("_")) continue;
            HashMap<String, EntityAssetType> byName = new HashMap<String, EntityAssetType>();
            JSONArray names = assetTypesJson.getJSONArray(typeString);
            for (int cursor = 0; cursor < names.size(); ++cursor) {
                EntityAssetType entityAssetType = new EntityAssetType(names.getString(cursor));
                byName.put(entityAssetType.name, entityAssetType);
                this.all.add(entityAssetType);
                if (this.allByName.containsKey(entityAssetType.name)) {
                    throw new RuntimeException("Multiple entity asset types with same name: " + entityAssetType.name);
                }
                this.allByName.put(entityAssetType.name, entityAssetType);
            }
            EntityType entityType = EntityType.valueOf(typeString);
            this.byEntityType.put(entityType, byName);
        }
    }

    public List<EntityAssetType> getAll() {
        return this.all;
    }

    public EntityAssetType getByName(String name) {
        return this.allByName.get(name);
    }

    public Collection<EntityAssetType> getByEntityType(EntityType entityType) {
        if (!this.byEntityType.containsKey((Object)entityType)) {
            return Collections.emptyList();
        }
        return this.byEntityType.get((Object)entityType).values();
    }
}

